﻿/* Skript zur Demonstration von Unterabfragen in Joins
 * Als Benutzer SCOTT ausführen
 */
 
-- ANTI-JOIN
select ename, job, sal
  from emp
 where deptno not in
       (select deptno
          from dept
         where loc = 'CHICAGO');
         
-- Vermeidung des Antijoins durch einen Inner Join
select ename, job, sal
  from emp e
  join dept d on e.deptno = d.deptno
 where d.loc != 'CHICAGO';
 
-- SEMI-JOIN
select deptno, dname, loc
  from dept d
 where exists
       (select 1
          from emp e
         where e.deptno = d.deptno
           and e.sal >= 3000);
           
-- Schlechter Ersatz mit einem Inner Join
select distinct d.deptno, d.dname, d.loc
  from dept d
  join emp e on d.deptno = e.deptno
 where e.sal >= 3000;